﻿package {
	import flash.events.*;
	import flash.display.*;
	import fl.data.DataProvider;
	import fl.controls.*;
	import Dialog;
	
	public class UploadedEditPanel extends MovieClip{
		public var dispatcher:EventDispatcher = new EventDispatcher();		
		public var tempList:XMLList;
		public var comboProvider:DataProvider;
		
		//inner elements:
		//mc_grid
		//mc_buttonMoveAll
		//mc_buttonMoveSelected
		//mc_buttonDeleteSelected
		//mc_buttonDeleteAll
		//mc_buttonRefresh
		//mc_buttonRefresh2
		//mc_buttonSelectAll
		
		//constructor:
		public function UploadedEditPanel(){
			this.addFrameScript(1,mainScript);
			
			//this.addFrameScript(0,mainScript);
			//this.addFrameScript(2,mainScript);
		}
		
		//-----------------------------------------------------------------
		// show the alert box
		public function alertError(text:String){
			var website = this.parent;
			website.showDialog("textonly","There is some error",text);
		}
		
		//-----------------------------------------------------------------
		// jump to preloader
		public function jumpToPreloader(){
			this.gotoAndStop(1);
		}
		
		//-----------------------------------------------------------------
		// jump to preloader
		public function jumpToNoFiles(){			
			this.addFrameScript(2,noFilesScript);	//set frame script
			this.gotoAndStop(3);
		}
		
		//-----------------------------------------------------------------
		// jump to main progress window
		public function jumpToMain(){
			this.addFrameScript(1,mainScript);	//set frame script
			this.gotoAndStop(2);
		}
		
		//-----------------------------------------------------------------
		// sets categories grid from array
		public function setCategoriesList(arrCategories:Array){
			this.comboProvider = new DataProvider();
			
			var i:Number,category:Category;
			
			for(i=0;i<arrCategories.length;i++){
				category = arrCategories[i];
				if(category.type=="uploaded") continue;
				this.comboProvider.addItem({label:category.catName,data:category.id});
			}
			mc_comboCategories.dataProvider = this.comboProvider;
		}
		
		//-----------------------------------------------------------------
		// sets categories grid from array
		public function setUploadedFilesList(list:XMLList){
			this.tempList = list;
			if(list.length() == 0) jumpToNoFiles();
			else jumpToMain();			
		}
		
		//-----------------------------------------------------------------
		// set all button events.
		private function setMainFrameButtonEvents(){
			mc_buttonDeleteSelected.addEventListener(MouseEvent.CLICK,buttonDeleteSelectedClick_handler);
			mc_buttonDeleteAll.addEventListener(MouseEvent.CLICK,buttonDeleteAllClick_handler);
			mc_buttonMoveSelected.addEventListener(MouseEvent.CLICK,buttonMoveSelected_handler);
			mc_buttonRefresh.addEventListener(MouseEvent.CLICK,buttonRefreshClick_handler);
			mc_buttonSelectAll.addEventListener(MouseEvent.CLICK,buttonSelectAllClick_handler);
			mc_buttonMoveAll.addEventListener(MouseEvent.CLICK,buttonMoveAllClick_handler);
		}
				
		//-----------------------------------------------------------------
		// run the main frame script. to be executed when entered to the main script.
		private function mainScript(){
			setMainFrameButtonEvents();
			
			//set grid properties
			mc_grid.selectable = true;
			mc_grid.sortableColumns = true;
			mc_grid.allowMultipleSelection = true;
			
			//tell parent to run update combo box function.
			dispatcher.dispatchEvent(new Event("updateUploadPanelCatList"));
			var fileName:String,i:Number;
			var provider:DataProvider = new DataProvider;
			
			// update the files grid list
			for(i=0;i<this.tempList.length();i++){				
				fileName = this.tempList[i].toString();
				provider.addItem({Filename:fileName});
			}
			mc_grid.dataProvider = provider;
						
			this.addFrameScript(1,null);
		}
		
		//---------------------------------------------------------------
		//run the nofiles script. set refresh2 buton events
		private function noFilesScript(){
			mc_buttonRefresh2.addEventListener(MouseEvent.CLICK,buttonRefreshClick_handler);
			this.addFrameScript(2,null);
		}
		
		//---------------------------------------------------------------
		//get selected items array
		public function getArrSelectedFilenames(){
			var selectedItems:Array = mc_grid.selectedItems;
			var item:Object,i:Number;
			var arrFilenames:Array = new Array();
			
			for(i=0;i<selectedItems.length;i++){
				item = selectedItems[i];
				arrFilenames.push(item.Filename);
			}			
			return(arrFilenames);
		}
		
		//---------------------------------------------------------------
		//get category id from combo box.
		public function getCategoryID(){
			var catID:String = mc_comboCategories.selectedItem.data;
			return(catID);
		}
		
		//===================== Mouse Events ===========================
		// delete selected click event
		private function buttonDeleteSelectedClick_handler(event:MouseEvent){
			if(mc_grid.selectedItems.length ==0) alertError("No files selected");
			else dispatcher.dispatchEvent(new Event("deleteUploadedSelectedFiles"));
		}

		//---------------------------------------------------------------
		// delete all click event.
		private function buttonDeleteAllClick_handler(event:MouseEvent){
			dispatcher.dispatchEvent(new Event("deleteAllUploadedFiles"));
		}
		
		//---------------------------------------------------------------
		// send command to website to refresh uploaded list.
		public function refreshUploadedList(refreshCategoriesAfter:Boolean){
			var website = this.parent;
			website.getUploadedFilesList(refreshCategoriesAfter);
		}
				
		//---------------------------------------------------------------
		// refresh list click event with refreshing 
		private function buttonRefreshClick_handler(event:MouseEvent){
			refreshUploadedList(false);
		}
		
		//---------------------------------------------------------------
		// move all click event
		private function buttonMoveAllClick_handler(event:MouseEvent){
		}
		
		//---------------------------------------------------------------
		// move selected click event
		private function buttonMoveSelected_handler(event:MouseEvent){
			if(mc_grid.selectedItems.length ==0) alertError("No files selected");
			else dispatcher.dispatchEvent(new Event("moveUploadedSelectedFiles"));
		}
		
		//---------------------------------------------------------------
		// select all rows in the drig
		private function buttonSelectAllClick_handler(event:MouseEvent){			
			var arr:Array = new Array();			
			for(var i=0;i<mc_grid.length;i++){
				arr[i]=i;
			}
			mc_grid.selectedIndices = arr;
		}
		
		//---------------------------------------------------------------
		// get filenames array
		public function getArrFilenames(){
			var arrItems:Array = mc_grid.dataProvider.toArray();
			var arrFilenames:Array = new Array();
			for(var i=0;i<arrItems.length;i++){
				arrFilenames.push(arrItems[i].Filename);
			}
			return(arrFilenames);
		}
		
		//---------------------------------------------------------------
		// show error messages, refreshes file list, and after that category list.
		public function moveFilesResponse(xmlData:XML){
			var numErrors:Number = xmlData.numErrors;
			var website = this.parent;
			
			if(numErrors >= 1){
				var txt:String = numErrors+" files not moved. Wrong type";
				website.showDialog("error","Error moving files",txt);
			}
			else website.showDialog("textonly","","All files moved successfully");
			
			refreshUploadedList(true);	// refresh upload with refreshing categories.
		}
		
	}
}